<?php
header('Content-Type: application/json; charset=UTF-8');

$db = new SQLite3(__DIR__ . '/.db.db');

$username =
    $_GET['username']
    ?? $_GET['user']
    ?? $_POST['username']
    ?? $_POST['user']
    ?? '';

$password =
    $_GET['password']
    ?? $_GET['pass']
    ?? $_POST['password']
    ?? $_POST['pass']
    ?? '';

if ($username === '' || $password === '') {
    echo json_encode(["user_info" => null]);
    exit;
}

/* PANEL USERS */
$stmt = $db->prepare("
    SELECT username, password, status, expiry
    FROM extra_accounts
    WHERE username = :u AND password = :p
    LIMIT 1
");
$stmt->bindValue(':u', $username, SQLITE3_TEXT);
$stmt->bindValue(':p', $password, SQLITE3_TEXT);
$res = $stmt->execute();
$row = $res->fetchArray(SQLITE3_ASSOC);

if ($row) {
    if (
        $row['status'] === 'Active' &&
        (empty($row['expiry']) || strtotime($row['expiry']) >= time())
    ) {
        echo json_encode([
            "user_info" => [
                "username" => $row['username'],
                "password" => $row['password'],
                "auth" => 1,
                "status" => "Active",
                "is_trial" => 0,
                "active_cons" => 0,
                "max_connections" => 1,
                "created_at" => time()
            ]
        ]);
        exit;
    }
}

echo json_encode(["user_info" => null]);
exit;
