<?php
header('Content-Type: application/json; charset=UTF-8');

/*
|--------------------------------------------------------------------------
| Read credentials from ALL CinemaHQ / XC formats
|--------------------------------------------------------------------------
*/
$raw = file_get_contents("php://input");
$json = json_decode($raw, true);

$username =
    $_POST['username']
    ?? $_POST['user']
    ?? $_POST['u']
    ?? $_GET['username']
    ?? $_GET['user']
    ?? $_GET['u']
    ?? $json['username']
    ?? $json['user']
    ?? '';

$password =
    $_POST['password']
    ?? $_POST['pass']
    ?? $_POST['p']
    ?? $_GET['password']
    ?? $_GET['pass']
    ?? $_GET['p']
    ?? $json['password']
    ?? $json['pass']
    ?? '';

if ($username === '' || $password === '') {
    echo json_encode([
        "user_info" => [
            "auth" => 0,
            "message" => "Missing credentials"
        ]
    ]);
    exit;
}

$db = new SQLite3(__DIR__ . '/.db.db');

/*
|--------------------------------------------------------------------------
| 1️⃣ PANEL USERS (WORK EVEN IF DNS IS EMPTY)
|--------------------------------------------------------------------------
*/
$stmt = $db->prepare("
    SELECT username, password, status, expiry
    FROM extra_accounts
    WHERE username = :u AND password = :p
    LIMIT 1
");
$stmt->bindValue(':u', $username, SQLITE3_TEXT);
$stmt->bindValue(':p', $password, SQLITE3_TEXT);
$res = $stmt->execute();
$row = $res->fetchArray(SQLITE3_ASSOC);

if ($row) {
    $expired = (!empty($row['expiry']) && strtotime($row['expiry']) < time());

    echo json_encode([
        "user_info" => [
            "username" => $row['username'],
            "password" => $row['password'],
            "auth"     => $expired ? 0 : 1,
            "status"   => $expired ? "Expired" : "Active",
            "message"  => $expired ? "Account expired" : "Login successful!"
        ]
    ]);
    exit;
}

/*
|--------------------------------------------------------------------------
| 2️⃣ XC USERS (ONLY IF DNS EXISTS)
|--------------------------------------------------------------------------
*/
$dns = $db->querySingle("SELECT url FROM dns WHERE url != '' LIMIT 1");

if ($dns) {
    echo json_encode([
        "user_info" => [
            "auth" => 1,
            "status" => "Active",
            "message" => "XC login"
        ]
    ]);
    exit;
}

/*
|--------------------------------------------------------------------------
| 3️⃣ FAIL
|--------------------------------------------------------------------------
*/
echo json_encode([
    "user_info" => [
        "auth" => 0,
        "message" => "Invalid username or password"
    ]
]);
